/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */

'use strict';

// Jasmine Unit Testing Suite
define(["jquery", "backbone", "marionette"
	//, "loader", "jqueryui", "jquerymobile"
	, "jasminejquery"
	, 'applets/wound-care-applet/core/views/AppletView'],
	function ($, Backbone, Marionette, notUsed, AppletView) {
		var controller;
		var view,
			viewEl,
			collection,
			model;

		describe("Skin Check main page", function () {
			beforeEach(function() {
				//Portal = jasmine.createSpy('portal').andReturn(function(){});
				//Portal.patient = jasmine.createSpy('patient').andReturn(function() {});
				//controller = Portal.WoundCareApplet.Controller();
				model = new Backbone.Model({link:['link'],
					bradenAssessment:{status:'ACTIVE'},
					skinInspection:{status:'ACTIVE'}
				});
				view = new AppletView({model:model});
				viewEl = view.render().$el;
			});
			afterEach(function() {
				viewEl.remove();
			});
			it("should have correct link names", function () {


				expect(viewEl.find('a[href="#new-inspection"]').text()).toBe('Skin Assessment');
				expect(viewEl.find('a[href="#braden-scale"]').text()).toBe('Braden Assessment');
				expect(viewEl.find('a[href="#prev-inspections"]').text()).toBe('Previous Assessments');
				expect(viewEl.find('a[href="#risk-factors"]').text()).toBe('Additional Risk Factors');
				expect(viewEl.find('a[href="#education"]').text()).toBe('Educate');
			});
			it('should have correct app description', function() {
				//expect(viewEl.text()).toContain("For each patient, complete the Skin Assessment and Braden Scale forms. Refer to the Education and Additional Risks sections as needed. Use the Finalize button to open Notewriter, author, sign, and submit your progress note to Vista and complete the process.");
				expect(viewEl.find('.wc-p').text()).toBe("Use this app to document Skin and Risk Assessments. Use the Finalize button to launch Note Writer, author, sign, and submit your progress note to VistA to complete the assessment process.");
			});

		});
	});